IF OBJECT_ID('p_plug_Farma_tipoRegistro_Dez') IS NOT NULL
	BEGIN
		DROP PROCEDURE p_plug_Farma_tipoRegistro_Dez
	END
 
GO 



--EXEC [p_plug_Farma_tipoRegistro_Dez] 4, '2025-10-18', 1

CREATE PROCEDURE [dbo].[p_plug_Farma_tipoRegistro_Dez] (@filial int, @data  date, @cd_emp INT= 1)
as
BEGIN
	declare @contador int;
	IF Object_id('tempDB..#TmpResVendas', 'U') IS NOT NULL
		DROP TABLE #TmpResVendas;
	/*********************************************************************************************/
		CREATE TABLE #TmpResVendas (tiporegistro			INT
									, numeroRegistroVenda	INT
									, datareferenciavenda		DATETIME
									, valortotalvendaliquido	MONEY
									, horareferenciavenda	DATETIME
									, numeronota			INT
									, tipopagamento			INT
									, numeroRegistroPessoa	INT
									, tiponotavenda			INT
									, serienota				VARCHAR(50)
									, serieecf				VARCHAR(50)
									, cd_vd					INT
									, uf					VARCHAR(2)
									, cod_cli				INT
									, cd_vend				int
									, delivery varchar(100)
									, ecommerce varchar(100)
									, canalEcommerce varchar(100)
									, detalheCanalEcommerce varchar(100)
									, numeroCaixa varchar(50))
		INSERT INTO  #TmpResVendas			
		EXEC p_plug_Farma_tipoRegistro_nove	@filial, @data, @cd_emp;
	/*********************************************************************************************/	
		CREATE TABLE #TmpRsItens (tiporegistro	int	
									,numeroregistroitemvenda	bigint
									,numeroregistrovenda	int
									,codigobarrasproduto	varchar(50)
									,quantidadeproduto	money
									,valorunitariobrutoproduto	money
									,valorunitarioliquidoproduto	money
									,valortotalliquidoitensregistro	money
									,valorcmv	money
									,tipoestoque	int
									,quantidadeestoque	money
									,pbmvenda	int
									,numeroregistrocolaborador	int
									,produtoprescrito	int	
									,codigobarrasvendido	varchar	(50)
									,cd_prod	int
									,numreg	varchar	(100)
									,cd_vd	int
									,vlrComissaoItem MONEY
									,vlrBonificacaoItem MONEY
									,vlrImpostoItem MONEY
									,vlrLucroItem MONEY
									,vlrAcrescimoItem MONEY)
	/*********************************************************************************************/	
	-- Vendas por cupom
		insert into #TmpRsItens
		SELECT
			   tiporegistro
			 , numeroregistroitemvenda
			 , numeroregistrovenda
			 , codigobarrasproduto
			 , quantidadeproduto
			 , valorunitariobrutoproduto
			 , valorunitarioliquidoproduto
			 , valortotalliquidoitensregistro
			 , valorcmv
			 , tipoestoque
			 , quantidadeestoque
			 , pbmvenda
			 , numeroregistrocolaborador
			 , produtoprescrito
			 , codigobarrasproduto codigobarrasvendido
			 , cd_prod
			 , numreg
			 , cd_vd
			 , vlrComissaoItem
			 , vlrBonificacaoItem
			 , vlrImpostoItem
			 , vlrLucroItem
			 , vlrAcrescimoItem
		FROM
			(SELECT
				10 AS tipoRegistro
				, ROW_NUMBER() OVER(ORDER BY IT.cd_vd ASC) AS numeroRegistroItemVenda
				, t.numeroRegistroVenda AS numeroRegistroVenda
				, COALESCE((SELECT TOP 1 cd_barra FROM est_prod_cd_barra WHERE ean_caixa_fechada = 0 
																	AND EAN_VALIDO=1
											AND cd_emp = PROD.cd_emp AND cd_prod = PROD.cd_prod ORDER BY cd_barra),
												case when cpl.tp_prod = 10 then '88888888888888' else '99999999999999' end ) AS codigoBarrasProduto
				, IT.qt_it AS quantidadeProduto
				, IT.vlr_it AS valorUnitarioBrutoProduto
				, ((CASE WHEN (it.TOT_IT - it.VLR_DESC_TOT_RAT) > 0 THEN 
					it.TOT_IT - it.VLR_DESC_TOT_RAT ELSE 	0 END)  / IT.qt_it) AS valorUnitarioLiquidoProduto
				, (CASE WHEN (it.TOT_IT - it.VLR_DESC_TOT_RAT) > 0 THEN 
					it.TOT_IT - it.VLR_DESC_TOT_RAT ELSE 	0 END) AS valorTotalLiquidoItensRegistro
				, IT.vlr_custo_medio AS valorCmv
				, case when IT.qt_est_ant >= 0 then 1 else 0 end AS tipoEstoque
				, IT.qt_est_ant AS quantidadeEstoque
				 , case when CONV.ds_conv IS NULL then 0
					else (CASE CONV.ds_conv WHEN 'VIDALINK' THEN 1
													 WHEN 'ORIZON/PREVSAUDE' THEN 2
													 WHEN 'EPHARMA' THEN 3
													 WHEN 'FARMACIA POPULAR' THEN 4
													 WHEN 'PHARMA SYSTEM' THEN 5
													 WHEN 'FUNCIONAL CARD' THEN 6
													 WHEN 'NOVARTIS' THEN 7
													 ELSE 99
												 END ) end AS pbmVenda
				 , IT.cd_vend AS numeroRegistroColaborador
				 ,case when PROD.controle_sngpc = 1 then 2
						  when PROD.antibiotico = 1 then 1
						else 99 end AS produtoPrescrito
				 , it.cd_barra AS codigoBarrasVendido
				 , PROD.cd_prod
				 , convert(varchar(20), PROD.cd_prod) +  '-' + convert(varchar(20),IT.cd_it) +  '-' + convert(varchar(20), IT.cd_vd) AS numReg
				 , IT.cd_vd
				 , ISNULL(((IT.QT_IT * IT.VLR_COMISSAO_FABRIC) + ROUND((((IT.TOT_IT - IT.VLR_DESC_TOT_RAT) * IT.PERC_COMIS) / 100),2)),0) as vlrComissaoItem
				 , 0 as vlrBonificacaoItem
				 , ISNULL((IT.vlr_icms+IT.VLR_PIS +IT.VLR_COFINS+IT.vlr_fecop-IT.VLR_ICMS_DESONERADO_IT),0) as vlrImpostoItem
				 , ISNULL(((IT.TOT_IT / IT.QT_IT) - IT.VLR_CUSTO),0) as vlrLucroItem
				 , 0 as vlrAcrescimoItem
			FROM
				 pdv_vd_it IT
				INNER JOIN est_prod_cpl cpl ON   CPL.cd_emp  = IT.cd_emp
											 AND CPL.cd_prod = IT.cd_prod
											 AND CPL.cd_FILIAL = IT.cd_FILIAL
				 INNER JOIN est_prod PROD ON PROD.cd_emp = IT.cd_emp
											 AND PROD.cd_prod = IT.cd_prod
				 JOIN #TmpResVendas t ON IT.cd_vd = t.cd_vd
										 AND IT.cd_filial = @filial
										 AND IT.cd_emp = 1
										 AND T.tiponotavenda <> 4--Nota Fiscal
				 LEFT JOIN pdv_vd_it_vd_pbm PBM ON PBM.cd_emp = IT.cd_emp
												   AND PBM.cd_filial = IT.cd_filial
												   AND PBM.cd_vd = IT.cd_vd
												   AND PBM.cd_it = IT.cd_it
				 LEFT JOIN rc_cli_conv CONV ON CONV.cd_emp = PBM.cd_emp
											   AND CONV.cd_filial = PBM.cd_filial
											   AND CONV.cd_cli = PBM.cd_cli_pbm
			WHERE it.cd_emp = @cd_emp
				  AND IT.cd_filial = @filial
				  and it.st_it=1
		) AS VENDASITENS
	/*********************************************************************************************/
	 --Vendas nota fiscal
	/*********************************************************************************************/
		Set @contador =isnull((select max(numeroRegistroItemVenda) from #TmpRsItens),0) 
		insert into #TmpRsItens
		SELECT
				tiporegistro
				, @contador+numeroregistroitemvenda
				, numeroregistrovenda
				, codigobarrasproduto
				, quantidadeproduto
				, valorunitariobrutoproduto
				, valorunitarioliquidoproduto
				, valortotalliquidoitensregistro
				, valorcmv
				, tipoestoque
				, quantidadeestoque
				, pbmvenda
				, numeroregistrocolaborador
				, produtoprescrito
				, codigobarrasproduto codigobarrasvendido
				, cd_prod
				, numreg
				, cd_nf
				, vlrComissaoItem
				, vlrBonificacaoItem
				, vlrImpostoItem
				, vlrLucroItem
				, vlrAcrescimoItem
		FROM
			(SELECT
				10 AS tipoRegistro
				, ROW_NUMBER() OVER(ORDER BY IT.cd_NF ASC) AS numeroRegistroItemVenda
				, t.numeroRegistroVenda AS numeroRegistroVenda
				, COALESCE((SELECT TOP 1 cd_barra FROM est_prod_cd_barra WHERE ean_caixa_fechada = 0 
																	AND EAN_VALIDO=1
											AND cd_emp = PROD.cd_emp AND cd_prod = PROD.cd_prod ORDER BY cd_barra),
												case when cpl.tp_prod = 10 then '88888888888888' else '99999999999999' end ) AS codigoBarrasProduto
				, IT.qt_it AS quantidadeProduto
				, IT.vlr_it AS valorUnitarioBrutoProduto
				, IT.VLR_TOT_IT/IT.qt_it AS valorUnitarioLiquidoProduto
				, VLR_TOT_IT AS valorTotalLiquidoItensRegistro
				, IT.vlr_custo_md AS valorCmv
				, case when IT.qt_est_ant >= 0 then 1 else 0 end AS tipoEstoque
				, IT.qt_est_ant AS quantidadeEstoque
				,  99    AS pbmVenda
				, t.cd_vend AS numeroRegistroColaborador
				, 99 AS produtoPrescrito
				, COALESCE((SELECT TOP 1 cd_barra FROM est_prod_cd_barra WHERE ean_caixa_fechada = 0 
																	AND EAN_VALIDO=1
											AND cd_emp = PROD.cd_emp AND cd_prod = PROD.cd_prod ORDER BY cd_barra),
												case when cpl.tp_prod = 10 then '88888888888888' else '99999999999999' end ) AS codigoBarrasVendido
				, PROD.cd_prod
				, convert(varchar(20), PROD.cd_prod) +  '-' + convert(varchar(20),IT.cd_it) +  '-' + convert(varchar(20), IT.cd_nf) AS numReg
				, IT.cd_nf
				, (it.VLR_TOT_IT * (it.PERC_COMI/100) ) as vlrComissaoItem
				 , 0 as vlrBonificacaoItem
				 , ISNULL((it.VLR_PIS +it.VLR_ICMS_IT +it.VLR_COFINS +it.VLR_FECOP -it.VLR_ICMS_DESONERADO),0) as vlrImpostoItem
				 , isnull(((it.VLR_TOT_IT / it.QT_IT) - It.VLR_CUSTO),0) as vlrLucroItem
				 , 0 as vlrAcrescimoItem
			FROM
				est_nf_sai_it it
				INNER JOIN est_prod_cpl cpl ON   CPL.cd_emp  = IT.cd_emp
											 AND CPL.cd_prod = IT.cd_prod
											 AND CPL.cd_FILIAL = IT.cd_FILIAL
				INNER JOIN est_prod PROD ON PROD.cd_emp = IT.cd_emp
											AND PROD.cd_prod = IT.cd_prod
				JOIN #TmpResVendas t ON		IT.cd_nf	 = t.cd_vd
										AND IT.cd_filial = @filial
										AND IT.cd_emp	 = 1
										AND T.tiponotavenda = 4--Nota Fiscal
			WHERE it.cd_emp = @cd_emp
					AND IT.cd_filial = @filial 
		) AS VENDASITENS;
	/*********************************************************************************************/
		SELECT * 
		FROM 
			#TmpRsItens
		ORDER BY numeroregistroitemvenda;
END